:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: CONTENTS
::
:: 1 INSTRUCTIONS
:: 2 EXAMPLES
:: 3 CODE
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: 1 INSTRUCTIONS
::
:: This program is used to feed the result of the VC estimation
:: to a program of the user's choice. The default is the
:: program associated with CSV files on your computer.
::
:: The statistical program Gretl is recommended. This makes it
:: easy to generate graphics and do statistical analysis. To 
:: activate this, install Gretl and uncomment the line below 
:: the one marked with "GRETL". (Uncommenting a line is done by 
:: removing the double colon "::" including trailing spaces
:: at the beginning of the line.)
:: 
:: Another possibility is to activate any other program. This is
:: done by writing "set program=<path to the program>". As an 
:: example, consider LibreOffice Calc. This is activated by 
:: uncommenting the line below the one marked with "LibreOffice 
:: Calc". 
:: 
:: If another program is to be used, use the path to that 
:: program.
:: 
:: If the default for CSV files on your computer is to be 
:: restored, disable all lines starting with "set program=" by 
:: commenting them.
:: 
:: If the automatic piping feature is to be disabled, simply use
::
:: "set program="" ".
::  
:: Because paths look differently for 32 bit installations and 
:: 64 bit installations, and also for different languages, the
:: paths used below may have to corrected accordingly. 
::
::
:: For further information, see the VC help file.
::
::::::::::::END OF INSTRUCTIONS:::::::::::::::::::::::::::::::::::
::
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: 2 EXAMPLES
::
:: Enable an example by removing "::" before "set program= "
:: and disable all other lines by putting "::" at the beginning
:: of all other lines starting with "set program=  ".
:: The example commands may have to be adatped to you Windows 
:: version (32 or 64 bit) and your language.
:: All examples are provided for Windows 10 (64 bit) English.
::  
::...........SEND TO ASSOCIATED PROGRAM (DEFAULT)................. 

set program=

::...........DISABLE PIPING.......................................

:: set program=""

::...........SEND TO GRETL........................................
 
:: set program="C:\Program Files\gretl\gretl.exe"

::...........SEND TO LibreOffice Calc.............................

:: set program="C:\Program Files\LibreOffice\program\scalc.exe"

::...........SEND TO Microsoft Excel..............................

:: set program="C:\Program Files (x86)\Microsoft Office\Office14\EXCEL.EXE"

:: ..........SEND TO NOTEPAD++....................................

:: set program="C:\Program Files\Notepad++\notepad++.exe"
::
:: ..........SEND TO NOTEPAD....................................

:: set program="notepad.exe"


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: 3 CODE
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::          DON'T CHANGE ANYTHING BELOW                

set filename=%1

start /min cmd /c  "%program% %filename%"

exit

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::